#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<pthread.h>

#define THREAD_COUNT 20
#define N 3
#define SEVER 0
#define JUG 1
#define AUTO 0
#define BUS 1
#define KAMION 2

int brVozilaSever = 0;
int brVozilaJug = 0;
int brAutobusa = 0;
int brKamiona = 0;
int smer = SEVER;

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

typedef struct Vozilo
{
    int tipVozila;
}Vozilo;

void *sever(void *index)
{
    long id = (long) index;

    Vozilo vozilo;
    int tip = rand() % 3;
    vozilo.tipVozila = tip;

    sleep(rand() % N);
    if(vozilo.tipVozila == AUTO)
    {
        printf("Ja sam automobil %ld i cekam da predjem nadvoznjak sever - jug\n", id);
    }
    else if(vozilo.tipVozila == BUS)
    {
        printf("Ja sam autobus %ld i cekam da predjem nadvoznjak sever - jug\n", id);
    }
    else
    {
        printf("Ja sam kamion %ld i cekam da predjem nadvoznjak sever - jug\n", id);
    }

    pthread_mutex_lock(&mutex);
    {
        if(vozilo.tipVozila == AUTO)
        {
            while(brVozilaJug != 0 || brKamiona != 0)
            {
                pthread_cond_wait(&cond, &mutex);
            }

            brVozilaSever++;
        }
        else if(vozilo.tipVozila == BUS)
        {
            while(brVozilaJug != 0 || brAutobusa != 0 || brKamiona != 0)
            {
                pthread_cond_wait(&cond, &mutex);
            }

            brVozilaSever++;
            brAutobusa++;
        }
        else 
        {
            while(brVozilaJug != 0 || (brVozilaJug + brVozilaSever) != 0)
            {
                pthread_cond_wait(&cond, &mutex);
            }

            brVozilaSever++;
            brKamiona++;
        }

        printf("Trenutno stanje: Ukupno: %d, Sever: %d, Jug: %d, Autobusa: %d, Kamiona: %d\n", (brVozilaJug + brVozilaSever), brVozilaSever, brVozilaJug, brAutobusa, brKamiona);
    }
    pthread_mutex_unlock(&mutex);

    if(vozilo.tipVozila == AUTO)
    {
        printf("Automobil %ld prelazi nadvoznjak, sever - jug\n", id);
    }
    else if(vozilo.tipVozila == BUS)
    {
        printf("Autobus %ld prelazi nadvoznjak, sever - jug\n", id);
    }
    else
    {
        printf("Kamion %ld prelazi nadvoznjak, sever - jug\n", id);
    }

    sleep(rand() % N);

    if(vozilo.tipVozila == AUTO)
    {
        printf("Automobil %ld je presao nadvoznjak\n", id);
    }
    else if(vozilo.tipVozila == BUS)
    {
        printf("Autobus %ld je presao nadvoznjak\n", id);
    }
    else
    {
        printf("Kamion %ld je presao nadvoznjak\n", id);
    }

    pthread_mutex_lock(&mutex);
    {
        
        printf("Trenutno stanje: Ukupno: %d, Sever: %d, Jug: %d, Autobusa: %d, Kamiona: %d\n", (brVozilaJug + brVozilaSever), brVozilaSever, brVozilaJug, brAutobusa, brKamiona);
        if(vozilo.tipVozila == AUTO)
        {
            brVozilaSever--;
            pthread_cond_broadcast(&cond);
        }
        else if(vozilo.tipVozila == BUS)
        {
            brVozilaSever--;
            brAutobusa--;
            pthread_cond_broadcast(&cond);
        }
        else
        {
            brVozilaSever--;
            brKamiona--;
            pthread_cond_broadcast(&cond);
        }
    }
    pthread_mutex_unlock(&mutex);
}

void *jug(void *index)
{
long id = (long) index;

    Vozilo vozilo;
    int tip = rand() % 3;
    vozilo.tipVozila = tip;

    sleep(rand() % N);
    if(vozilo.tipVozila == AUTO)
    {
        printf("Ja sam automobil %ld i cekam da predjem nadvoznjak jug - sever\n", id);
    }
    else if(vozilo.tipVozila == BUS)
    {
        printf("Ja sam autobus %ld i cekam da predjem nadvoznjak jug - sever\n", id);   
    }
    else
    {
        printf("Ja sam kamion %ld i cekam da predjem nadvoznjak jug - sever\n", id);
    }

    pthread_mutex_lock(&mutex);
    {
        if(vozilo.tipVozila == AUTO)
        {
            while(brVozilaSever != 0 || brKamiona != 0)
            {
                pthread_cond_wait(&cond, &mutex);
            }

            brVozilaJug++;
        }
        else if(vozilo.tipVozila == BUS)
        {
            while(brVozilaSever != 0 || brAutobusa != 0 || brKamiona != 0)
            {
                pthread_cond_wait(&cond, &mutex);
            }

            brVozilaJug++;
            brAutobusa++;
        }
        else 
        {
            while(brVozilaSever != 0 || (brVozilaJug + brVozilaSever) != 0)
            {
                pthread_cond_wait(&cond, &mutex);
            }

            brVozilaJug++;
            brKamiona++;
        }

        printf("Trenutno stanje: Ukupno: %d, Sever: %d, Jug: %d, Autobusa: %d, Kamiona: %d\n", (brVozilaJug + brVozilaSever), brVozilaSever, brVozilaJug, brAutobusa, brKamiona);
    }
    pthread_mutex_unlock(&mutex);

    if(vozilo.tipVozila == AUTO)
    {
        printf("Automobil %ld prelazi nadvoznjak, jug - sever\n", id);
    }
    else if(vozilo.tipVozila == BUS)
    {
        printf("Autobus %ld prelazi nadvoznjak, jug - sever\n", id);
    }
    else
    {
        printf("Kamion %ld prelazi nadvoznjak, jug - sever\n", id);
    }

    sleep(rand() % N);

    if(vozilo.tipVozila == AUTO)
    {
        printf("Automobil %ld je presao nadvoznjak\n", id);
    }
    else if(vozilo.tipVozila == BUS)
    {
        printf("Autobus %ld je presao nadvoznjak\n", id);
    }
    else
    {
        printf("Kamion %ld je presao nadvoznjak\n", id);
    }

    pthread_mutex_lock(&mutex);
    {
        printf("Trenutno stanje: Ukupno: %d, Sever: %d, Jug: %d, Autobusa: %d, Kamiona: %d\n", (brVozilaJug + brVozilaSever), brVozilaSever, brVozilaJug, brAutobusa, brKamiona);
        if(vozilo.tipVozila == AUTO)
        {
            brVozilaJug--;
            pthread_cond_broadcast(&cond);
        }
        else if(vozilo.tipVozila == BUS)
        {
            brVozilaJug--;
            brAutobusa--;
            pthread_cond_broadcast(&cond);
        }
        else
        {
            brVozilaJug--;
            brKamiona--;
            pthread_cond_broadcast(&cond);
        }
    }
    pthread_mutex_unlock(&mutex);
}

int main()
{
    pthread_t threads[THREAD_COUNT];

    long i;
    for(i = 0; i < THREAD_COUNT; i++)
    {
        pthread_create(threads + i, NULL, i % 2 ? sever : jug, (void *) i);
    }

    pthread_exit(NULL);
}